#ifndef __RANDOM_
#define __RANDOM_

#include "Types.h"
#include "Debug.h"
#include <stdlib.h>
#include <time.h>

#ifdef __cplusplus
extern "C" {
#endif

extern void InitializeRandom(void);
extern UINT32 Random( UINT32 uiRange );

//Chance( 74 ) returns TRUE 74% of the time.	If uiChance >= 100, then it will always return TRUE.
extern BOOLEAN Chance( UINT32 uiChance );

//Wizardry can use it too, but I'm saving them a K in the meantime...
//If Wizardry wants it, then removing the #ifdef JA2 will make it work.
#ifdef JA2
	#define PRERANDOM_GENERATOR
#endif

#ifdef PRERANDOM_GENERATOR
	//Returns a pregenerated random number.	
	//Used to deter Ian's tactic of shoot, miss, restore saved game :)
	extern UINT32 PreRandom( UINT32 uiRange );
	extern BOOLEAN PreChance( UINT32 uiChance );

	//IMPORTANT:	Changing this define will invalidate the JA2 save.	If this
	//						is necessary, please ifdef your own value.
	#define MAX_PREGENERATED_NUMS			256		
	extern UINT32 guiPreRandomIndex;
	extern UINT32 guiPreRandomNums[ MAX_PREGENERATED_NUMS ];
#endif

#ifdef __cplusplus
}
#endif

#endif